/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.registry.FluidRegistry;

public class TeapotItem
extends BlockItem {
    private final int capacity;
    private final boolean canFillWater;

    public TeapotItem(Block block, Item.Properties properties, int capacity, boolean fillWater) {
        super(block, properties);
        this.capacity = capacity;
        this.canFillWater = fillWater;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemStack(stack, this.capacity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (this.canFillWater) {
            ItemStack itemStack = playerIn.m_21120_(handIn);
            BlockHitResult raytraceresult = TeapotItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (raytraceresult.m_6662_() == HitResult.Type.MISS) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
            }
            if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
            }
            BlockHitResult blockraytraceresult = raytraceresult;
            BlockPos blockpos = blockraytraceresult.m_82425_();
            if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos, blockraytraceresult.m_82434_(), itemStack)) {
                FlowingFluid fluid;
                BlockState blockstate1 = worldIn.m_8055_(blockpos);
                if (blockstate1.m_60734_() instanceof LiquidBlock && (fluid = ((LiquidBlock)blockstate1.m_60734_()).getFluid()) != Fluids.f_76191_ && fluid.m_205067_(FluidTags.f_13131_)) {
                    ((LiquidBlock)blockstate1.m_60734_()).m_142598_((LevelAccessor)worldIn, blockpos, blockstate1);
                    playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    SoundEvent soundevent = SoundEvents.f_11770_;
                    playerIn.m_5496_(soundevent, 1.0f, 1.0f);
                    if (!playerIn.m_7500_()) {
                        ItemStack itemStack1 = new ItemStack((ItemLike)this);
                        CompoundTag fluidTag = new CompoundTag();
                        new FluidStack((Fluid)fluid, this.capacity).writeToNBT(fluidTag);
                        itemStack1.m_41784_().m_128365_("Fluid", (Tag)fluidTag);
                        ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)itemStack1);
                        itemStack.m_41774_(1);
                    }
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
                }
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void fillItemGroup(CreativeModeTab.Output group) {
        for (RegistryObject fluid : FluidRegistry.FLUIDS.getEntries()) {
            if (!(fluid.get() instanceof ForgeFlowingFluid.Source)) continue;
            ItemStack itemStack = new ItemStack((ItemLike)this);
            CompoundTag fluidTag = new CompoundTag();
            new FluidStack((Fluid)fluid.get(), this.capacity).writeToNBT(fluidTag);
            itemStack.m_41784_().m_128365_("Fluid", (Tag)fluidTag);
            group.m_246342_(itemStack);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41784_().m_128441_("Fluid")) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(f -> tooltip.add((Component)((MutableComponent)f.getFluidInTank(0).getDisplayName()).m_130946_(String.format(": %d / %dmB", f.getFluidInTank(0).getAmount(), this.capacity)).m_130940_(ChatFormatting.GRAY)));
        }
    }
}

